/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.builder;

import com.aptana.editor.php.internal.builder.LocalModule;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IModule;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public final class PHPLocalModuleFactory {
    private static final String COMPILED_SMARTY_REGEX = "(%%).+(%%).+";
    private static final String COMPILED_SMARTY_PREFIX = "%%";
    private static final String PHP_EXTENSION = "php";
    private static final String PHP_CONTENT_TYPE = "com.aptana.contenttype.phtml.php";

    public static IModule getModule(IResource resource, IBuildPath buildPath) {
        if (!resource.isAccessible()) {
            return null;
        }
        if (!(resource instanceof IFile)) {
            return null;
        }
        if (!resource.isSynchronized(1)) {
            return null;
        }
        IFile file = (IFile)resource;
        String fileName = file.getName();
        if (PHPLocalModuleFactory.hasValidExtension(fileName)) {
            if (fileName.startsWith(COMPILED_SMARTY_PREFIX) && fileName.matches(COMPILED_SMARTY_REGEX)) {
                return null;
            }
            return new LocalModule(file, buildPath);
        }
        return null;
    }

    public static IModule getModuleUnsafe(IResource resource, IBuildPath buildPath) {
        IFile file = (IFile)resource;
        if (PHPLocalModuleFactory.hasValidExtension(file.getName())) {
            return new LocalModule(file, buildPath);
        }
        return null;
    }

    private static boolean hasValidExtension(String fileName) {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType type = manager.getContentType(PHP_CONTENT_TYPE);
        if (type == null) {
            return fileName.endsWith(PHP_EXTENSION);
        }
        return type.isAssociatedWith(fileName);
    }

    private PHPLocalModuleFactory() {
    }
}

